/*
 * Decompiled with CFR 0.152.
 */
package panther.util.resource;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import panther.util.resource.CallableStatementWrapper;
import panther.util.resource.PreparedStatementWrapper;
import panther.util.resource.StatementWrapper;

public class ConnectionWrapper
implements Connection {
    private Connection conn;
    private List stmts = new ArrayList();
    private String DbUrl;
    private String DbUser;
    private String DbPwd;
    public static final String notImplemented = "This method is not implemented in the CachedResultSet";

    public ConnectionWrapper(Connection connection, String string, String string2, String string3) {
        this.conn = connection;
        this.DbUrl = string;
        this.DbUser = string2;
        this.DbPwd = string3;
    }

    public void resetConnection() {
        try {
            if (this.conn == null) {
                this.conn = DriverManager.getConnection(this.DbUrl, this.DbUser, this.DbPwd);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public PreparedStatement recreatePrepared(String string) throws SQLException {
        PreparedStatement preparedStatement = this.conn.prepareStatement(string);
        return preparedStatement;
    }

    public Statement recreateStatement() throws SQLException {
        Statement statement = this.conn.createStatement();
        return statement;
    }

    public CallableStatement recreateCallable(String string) throws SQLException {
        return this.conn.prepareCall(string);
    }

    public int getStatementCount() {
        return this.stmts.size();
    }

    public void removeStatement(Statement statement) {
        this.stmts.remove(statement);
    }

    public Statement createStatement() throws SQLException {
        StatementWrapper statementWrapper = new StatementWrapper(this.conn.createStatement(), this);
        this.stmts.add(statementWrapper);
        return statementWrapper;
    }

    public PreparedStatement prepareStatement(String string) throws SQLException {
        PreparedStatementWrapper preparedStatementWrapper = new PreparedStatementWrapper(this.conn.prepareStatement(string), this, string);
        this.stmts.add(preparedStatementWrapper);
        return preparedStatementWrapper;
    }

    public CallableStatement prepareCall(String string) throws SQLException {
        CallableStatementWrapper callableStatementWrapper = new CallableStatementWrapper(this.conn.prepareCall(string), this, string);
        this.stmts.add(callableStatementWrapper);
        return callableStatementWrapper;
    }

    public String nativeSQL(String string) throws SQLException {
        return this.conn.nativeSQL(string);
    }

    public void setAutoCommit(boolean bl) throws SQLException {
        this.conn.setAutoCommit(bl);
    }

    public boolean getAutoCommit() throws SQLException {
        return this.conn.getAutoCommit();
    }

    public void commit() throws SQLException {
        this.conn.commit();
    }

    public void rollback() throws SQLException {
        int n = this.stmts.size();
        for (int i = n - 1; i >= 0; --i) {
            if (this.stmts.get(i) == null) continue;
            ((Statement)this.stmts.get(i)).close();
        }
        this.conn.rollback();
    }

    public void close() throws SQLException {
        int n = this.stmts.size();
        for (int i = n - 1; i >= 0; --i) {
            if (this.stmts.get(i) == null) continue;
            ((Statement)this.stmts.get(i)).close();
        }
        this.conn.close();
    }

    public boolean isClosed() throws SQLException {
        return this.conn.isClosed();
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        return this.conn.getMetaData();
    }

    public void setReadOnly(boolean bl) throws SQLException {
        this.conn.setReadOnly(bl);
    }

    public boolean isReadOnly() throws SQLException {
        return this.conn.isReadOnly();
    }

    public void setCatalog(String string) throws SQLException {
        this.conn.setCatalog(string);
    }

    public String getCatalog() throws SQLException {
        return this.conn.getCatalog();
    }

    public void setTransactionIsolation(int n) throws SQLException {
        this.conn.setTransactionIsolation(n);
    }

    public int getTransactionIsolation() throws SQLException {
        return this.conn.getTransactionIsolation();
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.conn.getWarnings();
    }

    public void clearWarnings() throws SQLException {
        this.conn.clearWarnings();
    }

    public Statement createStatement(int n, int n2) throws SQLException {
        StatementWrapper statementWrapper = new StatementWrapper(this.conn.createStatement(n, n2), this);
        this.stmts.add(statementWrapper);
        return statementWrapper;
    }

    public PreparedStatement prepareStatement(String string, int n, int n2) throws SQLException {
        PreparedStatementWrapper preparedStatementWrapper = new PreparedStatementWrapper(this.conn.prepareStatement(string, n, n2), this, string);
        this.stmts.add(preparedStatementWrapper);
        return preparedStatementWrapper;
    }

    public CallableStatement prepareCall(String string, int n, int n2) throws SQLException {
        CallableStatementWrapper callableStatementWrapper = new CallableStatementWrapper(this.conn.prepareCall(string, n, n2), this, string);
        this.stmts.add(callableStatementWrapper);
        return callableStatementWrapper;
    }

    public Map getTypeMap() throws SQLException {
        return this.conn.getTypeMap();
    }

    public void setTypeMap(Map map) throws SQLException {
        this.conn.setTypeMap(map);
    }

    public void setHoldability(int n) throws SQLException {
        throw new UnsupportedOperationException(notImplemented);
    }

    public int getHoldability() throws SQLException {
        throw new UnsupportedOperationException(notImplemented);
    }

    public Savepoint setSavepoint() throws SQLException {
        throw new UnsupportedOperationException(notImplemented);
    }

    public Savepoint setSavepoint(String string) throws SQLException {
        throw new UnsupportedOperationException(notImplemented);
    }

    public void rollback(Savepoint savepoint) throws SQLException {
        throw new UnsupportedOperationException(notImplemented);
    }

    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        throw new UnsupportedOperationException(notImplemented);
    }

    public Statement createStatement(int n, int n2, int n3) throws SQLException {
        throw new UnsupportedOperationException(notImplemented);
    }

    public PreparedStatement prepareStatement(String string, int n, int n2, int n3) throws SQLException {
        throw new UnsupportedOperationException(notImplemented);
    }

    public CallableStatement prepareCall(String string, int n, int n2, int n3) throws SQLException {
        throw new UnsupportedOperationException(notImplemented);
    }

    public PreparedStatement prepareStatement(String string, int n) throws SQLException {
        throw new UnsupportedOperationException(notImplemented);
    }

    public PreparedStatement prepareStatement(String string, int[] nArray) throws SQLException {
        throw new UnsupportedOperationException(notImplemented);
    }

    public PreparedStatement prepareStatement(String string, String[] stringArray) throws SQLException {
        throw new UnsupportedOperationException(notImplemented);
    }
}

